/*********************************
 * My NoteBook helper routines   *
 *  stolen by deathlok from EDM  *
 *********************************/
#define INCL_DOS
#define INCL_PM
#include <os2.h>

#include "notebook.h"

void NBK_AddTab(HWND hwndNotebook, USHORT usType, ULONG ulNotebookPageResource, char *szTabText, PFNWP fnwpNotebookDialog, char *szStatusText )
{
 // Add a notebook tab

  ULONG ulPageID;
  HWND hwndPage;
  PDLGTEMPLATE ppb;

  ulPageID = (ULONG) WinSendMsg( hwndNotebook,
                                 BKM_INSERTPAGE,
                                 0L,
                                 MPFROM2SHORT( (BKA_STATUSTEXTON | BKA_AUTOPAGESIZE | usType ),
                                               BKA_LAST ) );
  if (szTabText)
    WinSendMsg( hwndNotebook,
                BKM_SETTABTEXT,
                MPFROMLONG( ulPageID ),
                MPFROMP( szTabText ) );
  if (szStatusText)
     WinSendMsg( hwndNotebook,
                 BKM_SETSTATUSLINETEXT,
                 MPFROMLONG( ulPageID ),
                 MPFROMP( szStatusText ) );
  DosGetResource( (HMODULE) NULL,
                  RT_DIALOG,
                  ulNotebookPageResource,
                  (PPVOID) &ppb);
  hwndPage = WinCreateDlg( HWND_DESKTOP,
                           (HWND) NULL,
                           fnwpNotebookDialog,
                           ppb,
                           NULL );
  DosFreeResource( (PVOID) ppb );
  WinSendMsg( hwndNotebook,
              BKM_SETPAGEWINDOWHWND,
              MPFROMLONG( ulPageID ),
              MPFROMHWND( hwndPage ) );
}

void NBK_AddMajor(HWND hwndNBK, ULONG ulNotebookPageResource, char *szTabText, PFNWP fnwpNotebookDialog, char *szStatusText )
{
// Add a major page
  NBK_AddTab( hwndNBK, BKA_MAJOR, ulNotebookPageResource, szTabText, fnwpNotebookDialog, szStatusText );
}

void NBK_AddMinor(HWND hwndNBK, ULONG ulNotebookPageResource, char *szTabText, PFNWP fnwpNotebookDialog, char *szStatusText )
{
 // Add a minor page
  NBK_AddTab( hwndNBK, BKA_MINOR, ulNotebookPageResource, szTabText, fnwpNotebookDialog, szStatusText );
}

MRESULT NBK_SendMessage(HWND hwndNotebook, ULONG ulPageID, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
     // Send a message to the window procedure of a notebook page

     MRESULT mReturn;
     if( ulPageID )
     {
          // Send the message to a specific notebook page

          HWND hwndPage = (HWND) WinSendMsg( hwndNotebook,
                                             BKM_QUERYPAGEWINDOWHWND,
                                             (MPARAM) ulPageID,
                                             0 );
          mReturn = WinSendMsg( hwndPage, msg, mp1, mp2 );
     }
     else
     {
          // Send the message to all notebook pages

          ulPageID = (ULONG) WinSendMsg( hwndNotebook,
                                         BKM_QUERYPAGEID,
                                         0,
                                         MPFROM2SHORT( BKA_FIRST, 0 ) );
          while( ulPageID )
          {
               NBK_SendMessage(hwndNotebook, ulPageID, msg, mp1, mp2 );
               ulPageID = (ULONG) WinSendMsg( hwndNotebook,
                                              BKM_QUERYPAGEID,
                                              MPFROMP( ulPageID ),
                                              MPFROM2SHORT( BKA_NEXT, 0 ) );
          }
     }

     return mReturn;
}


BOOL NBK_PostMessage(HWND hwndNotebook, ULONG ulPageID, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
     // Post a message to the window procedure of a notebook page

     BOOL bReturn;

     if( ulPageID )
     {
          // Post the message to a specific notebook page

          HWND hwndPage = (HWND) WinSendMsg( hwndNotebook,
                                             BKM_QUERYPAGEWINDOWHWND,
                                             (MPARAM) ulPageID,
                                             0 );
          bReturn = WinPostMsg( hwndPage, msg, mp1, mp2 );
     }
     else
     {
          // Post the message to all notebook pages

          ulPageID = (ULONG) WinSendMsg( hwndNotebook,
                                         BKM_QUERYPAGEID,
                                         0,
                                         MPFROM2SHORT( BKA_FIRST, 0 ) );
          while( ulPageID )
          {
               NBK_PostMessage(hwndNotebook, ulPageID, msg, mp1, mp2 );
               ulPageID = (ULONG) WinSendMsg( hwndNotebook,
                                              BKM_QUERYPAGEID,
                                              MPFROMP( ulPageID ),
                                              MPFROM2SHORT( BKA_NEXT, 0 ) );
          }
     }

     return bReturn;
}

MRESULT WinSetBtn(HWND hwnd,USHORT state )
{
  return WinPostMsg(hwnd,BM_SETCHECK,MPFROMSHORT(state),NULL);
}

MRESULT WinSetDlgBtn(HWND hwnd, ULONG ulID, USHORT state )
{
  return WinPostMsg(WinWindowFromID(hwnd,ulID),BM_SETCHECK,MPFROMSHORT(state),NULL);
}

/*
USHORT WinGetBtn(HWND hwnd )
{
  return SHORT1FROMMR( WinPostMsg(hwnd,BM_QUERYCHECK,NULL,NULL) );
}

USHORT WinGetDlgBtn(HWND hwnd, ULONG ulID )
{
  return SHORT1FROMMR( WinPostMsg(WinWindowFromID(hwnd,ulID),BM_QUERYCHECK,NULL,NULL) );
}

*/

USHORT WinGetBtn(HWND hwnd )
{
  return SHORT1FROMMR( WinSendMsg(hwnd,BM_QUERYCHECK,NULL,NULL) );
}

USHORT WinGetDlgBtn(HWND hwnd, ULONG ulID )
{
  return SHORT1FROMMR( WinSendDlgItemMsg(hwnd,ulID,BM_QUERYCHECK,NULL,NULL) );
}

